//=========== (C) Copyright 1999 Valve, L.L.C. All rights reserved. ===========
//
// The copyright to the contents herein is the property of Valve, L.L.C.
// The contents may be used and/or copied only with the written permission of
// Valve, L.L.C., or in accordance with the terms and conditions stipulated in
// the agreement/contract under which the contents have been supplied.
//=============================================================================

// No spaces in event names, max length 32
// All strings are case sensitive
//
// valid data key types are:
//   string : a zero terminated string
//   bool   : unsigned int, 1 bit
//   byte   : unsigned int, 8 bit
//   short  : signed int, 16 bit
//   long   : signed int, 32 bit
//   float  : float, 32 bit
//   local  : any data, but not networked to clients
//
// following key names are reserved:
//   local      : if set to 1, event is not networked to clients
//   unreliable : networked, but unreliable
//   suppress   : never fire this event
//   time	: firing server time
//   eventid	: holds the event ID

"ffevents"
{
	"player_sayteam"
	{
		"userid" "short"
		"text" "string"
	}
	"player_death"				// a game event, name may be 32 charaters long
	{
		// this extents the original player_death by a new 
		// field "headshot", all other fields remains the same
		"userid"	"short"
		"attacker"	"short"
		"weapon"	"string" 	// weapon name killer used 
		"damagetype" "short"	// damage type (if 'killer' is a trigger_hurt)
	}
	
	// From here down are events necessary for bot support.
	"player_changeclass"
	{		
		"userid"	"short"
		"oldclass"	"short"
		"newclass"	"short"
	}

	"build_dispenser"
	{
		"userid"	"short"	// who built it
	}

	"build_sentrygun"
	{
		"userid"	"short"
	}

	"build_detpack"
	{
		"userid"	"short"
	}

	"build_mancannon"
	{
		"userid"	"short"
	}
	
	"detpack_detonated"
	{
		"userid"	"short"
	}

	"sentrygun_killed"
	{
		"userid"	"short" // owner
		"attacker"	"short"
		"weapon"	"string"
	}

	"dispenser_killed"
	{
		"userid"	"short" // owner
		"attacker"	"short"
		"weapon"	"string"
	}
	
	"mancannon_killed"
	{
		"userid"	"short" // owner
		"attacker"	"short"
		"weapon"	"string"
	}
	
	"sentrygun_upgraded"
	{
		"userid"	"short" // owner
		"level"		"short"
	}

	"disguised"
	{
		"userid"	"short"
		"team"		"short"
		"class"		"short"
	}
	
	"disguise_lost"
	{
		"userid"	"short"
	}
	
	"uncloaked"
	{
		"userid"	"short"
	}
	
	"cloaked"
	{
		"userid"	"short"
	}
	
	"dispenser_enemyused"
	{
		"userid"	"short" // owner
		"enemyid"	"short"
	}
	
	"dispenser_detonated"
	{
		"userid"	"short"
	}
	
	"dispenser_dismantled"
	{
		"userid"	"short"
	}
	
	"dispenser_sabotaged"
	{
		"userid"	"short" // owner
		"saboteur"	"short" // who done it?
	}
	
	"sentry_detonated"
	{
		"userid"	"short"
	}
	
	"sentry_dismantled"
	{
		"userid"	"short"
	}
	
	"sentry_sabotaged"
	{
		"userid"	"short" // owner
		"saboteur"	"short" // who done it?
	}
	"player_additem"
	{
		"userid"	"short"
		"item"		"string"
	}
	"player_removeitem"
	{
		"userid"	"short"
		"item"		"string"
	}
	"player_removeallitems"
	{
		"userid"	"short"
	}
	"ff_restartround"
	{
	}

	"luaevent"
	{
		"luaid"			"short" 	// entity index of the Lua object (flag, ball, etc)
		"objid" 		"short" 	// entity index of some CBaseEntity* that is doing something to the lua object
		"name" 			"string" 	// name for the event - like flag_cap, flag_drop, etc - something stats programs could use

		// These next ones are just brainstorming...
		"field0"		"string"
		"field1"		"string"
		"field2"		"string"
		"field3"		"string"
		"field4"		"string"
		"field5"		"string"
		"field6"		"string"
		//"field7"		"string"
		//"field8"		"string"
		//"field9"		"string"
	}
}
