
local flags = {"red_flag1", "red_flag2", "red_flag3", "blue_flag1", "blue_flag2", "blue_flag3"}

IncludeScript("base_teamplay")

if POINTS_ALLCAP == nil then POINTS_ALLCAP = 25; end
if POINTS_PER_PERIOD == nil then POINTS_PER_PERIOD = 1; end
if PERIOD_TIME == nil then PERIOD_TIME = 30; end
POINTS_PER_CAPTURE = 2

function startup()
	-- set up team limits
	SetPlayerLimit(Team.kBlue, 0)
	SetPlayerLimit(Team.kRed, 0)
	SetPlayerLimit(Team.kYellow, -1)
	SetPlayerLimit(Team.kGreen, -1)
end


-----------------------------------------
-- base flag
-----------------------------------------
base_cp_flag = baseflag:new({
	botgoaltype = Bot.kFlag
})

function base_cp_flag:touch( player_id )

	local player = GetPlayer(player_id)
	local teamId = player:GetTeamId()

	-- make sure they don't have any flags already
	for i,v in ipairs(flags) do
		if player:HasItem(v) then return end
	end

	-- pickup if they can
	if self.notouch[player_id] then return; end
	if teamId == self.team then
		local flag = GetInfoScriptById(entid)
		flag:Pickup(player)
		player:SetDisguisable(false)
		player:SetCloakable( false )
		player:AddEffect(EF_SPEED_LUA1, 10000, 0, .5)
	end
end
function base_cp_flag:ownerdie( player_id )
	local flag = CastToInfoScript(entity)
	flag:Return()
end
function base_cp_flag:ownercloak( player_id )
	local flag = CastToInfoScript(entity)
	flag:Return()
end
function base_cp_flag:dropitemcmd( player_id )
	local flag = CastToInfoScript(entity)
	flag:Return()
end	

function base_cp_flag:onloseitem( player_id )
	-- remove the speed effect
	local player = GetPlayer(player_id)
	player:RemoveEffect(EF_SPEED_LUA1)

	player:SetDisguisable( true )
	player:SetCloakable( true )
	
	-- call
	baseflag.onloseitem(self, player_id)
end


-----------------------------------------
-- base capture point
-----------------------------------------
base_cp_cap = basecap:new({
	owner = 0,
	cp = 0,
	beam = "",
	botgoaltype = Bot.kFlagCap
})

function base_cp_cap:allowed ( player_id )
	local player = GetPlayer(player_id)
	local teamId = player:GetTeamId()
	
	-- don't want to cap again if we already have it
	if self.owner == teamId then return end

	for i,v in ipairs(self.item) do
		if player:HasItem( v ) then
			return 1
		end
	end
end
function base_cp_cap:updatebeam()
	local beam = GetEntityByName(self.beam)
	if not beam then return end
	beam = CastToBeam(beam)
	if not beam then return end
	--local spotlight = GetEntityByName(self.spotlight)
	--if not spotlight then return end
	
	if self.owner == 1 then
		beam:SetColor(255, 0, 0)
		--spotlight:SetRenderColor(255, 0, 0)
	elseif self.owner == 2 then
		beam:SetColor(0, 0, 255)
		--spotlight:SetRenderColor(0, 0, 255)
	else
		beam:SetColor(255, 255, 255)
		--spotlight:SetRenderColor(255, 255, 255)
	end
end

function base_cp_cap:oncapture(player_id, item)
	SmartSound(player_id, "yourteam.drop", "yourteam.drop", "otherteam.drop")

	--SmartSound(player_id, "vox.yourcap", "vox.yourcap", "vox.enemycap")
	-- vox would be too spammy i think
-- 	SmartMessage(player_id, "#FF_CP"..self.cp.."_YOUCAP", "#FF_CP"..self.cp.."_TEAMCAP", "#FF_CP"..self.cp.."_OTHERTEAMCAP")


	--Lets try it anyway, its cool..
	SmartSpeak(player_id, "CZ_GOTCP"..self.cp, "CZ_GOTCP"..self.cp, "CZ_LOSTCP"..self.cp)
 	SmartMessage(player_id, "FF_CZ2_YOURTEAM_CP"..self.cp, "FF_CZ2_YOURTEAM_CP"..self.cp, "#FF_CZ2_OTHERTEAM_CP"..self.cp.."_OTHERTEAMCAP")

	-- mark this team as having control
	local player = GetPlayer(player_id)
	local teamId = player:GetTeamId()	
	self.owner = teamId
	self:updatebeam()

	ConsoleToAll("Team "..teamId.." is now the owner of cp"..self.cp)
	
	-- add the schedule for points
	AddSchedule("cp"..self.cp.."points", PERIOD_TIME, self.addpoints, self)
	
	-- check if all points are done and fullcap
	local good = true
	for i,v in ipairs(allcaps) do
		if v.owner ~= self.owner then
			good = nil
		end
	end
	if good then -- all cap!
		-- give them points
		local team = GetTeam(teamId)
		if team then team:AddScore(POINTS_ALLCAP) end
		
		-- reset them all to no-owner
		for i,v in ipairs(allcaps) do
			v.owner = 0
			v:updatebeam()
		end		
	end
end

function base_cp_cap:addpoints()
	local team = GetTeam(self.owner)
	if team then
		team:AddScore(POINTS_PER_PERIOD)
	end
end


-----------------------------------------
-- control center
-----------------------------------------
base_controlcenter = info_ff_script:new({})
function base_controlcenter:onexplode(player_id)
	ConsoleToAll("Detpack exploded: "..player_id)
end 

-----------------------------------------
-- instanciate everything
-----------------------------------------
red_flag1 = base_cp_flag:new({ team = Team.kRed })
red_flag2 = base_cp_flag:new({ team = Team.kRed })
red_flag3 = base_cp_flag:new({ team = Team.kRed })
blue_flag1 = base_cp_flag:new({ team = Team.kBlue })
blue_flag2 = base_cp_flag:new({ team = Team.kBlue })
blue_flag3 = base_cp_flag:new({ team = Team.kBlue })

cp1_cap = base_cp_cap:new({ item=flags, cp = 1, beam = "cp1_skybeam_bottom", spotlight = "cp1_spotlight" })
cp2_cap = base_cp_cap:new({ item=flags, cp = 2, beam = "cp2_skybeam_bottom", spotlight = "cp2_spotlight" })
cp3_cap = base_cp_cap:new({ item=flags, cp = 3, beam = "cp3_skybeam_bottom", spotlight = "cp3_spotlight" })
cp4_cap = base_cp_cap:new({ item=flags, cp = 4, beam = "cp4_skybeam_bottom", spotlight = "cp4_spotlight" })
cp5_cap = base_cp_cap:new({ item=flags, cp = 5, beam = "cp5_skybeam_bottom", spotlight = "cp5_spotlight" })
allcaps = {cp1_cap, cp2_cap, cp3_cap, cp4_cap, cp5_cap}
