
-- base.lua

-----------------------------------------------------------------------------
-- This file is loaded automatically whenever a map is loaded.
-- Do not change this file.
-----------------------------------------------------------------------------
local _G = getfenv(0)

-----------------------------------------------------------------------------
-- defines
-----------------------------------------------------------------------------
-- Events
EVENT_ALLOWED = true
EVENT_DISALLOWED = false

-----------------------------------------------------------------------------
-- Output Events
-----------------------------------------------------------------------------
function OpenDoor(name) OutputEvent( name, "Open" ) end
function CloseDoor(name) OutputEvent( name, "Close" ) end
function ToggleDoor(name) OutputEvent( name, "Toggle" ) end

-----------------------------------------------------------------------------
-- baseclass (everything derives from this guy)
-----------------------------------------------------------------------------
baseclass = { }
function baseclass:new (o)
	-- create object if user does not provide one
	o = o or {}
	setmetatable(o, self)
	self.__index = self
	return o
end

-----------------------------------------------------------------------------
-- trigger_ff_script
-----------------------------------------------------------------------------
trigger_ff_script = baseclass:new({})
function trigger_ff_script:allowed() return EVENT_ALLOWED end
function trigger_ff_script:ontouch() end
function trigger_ff_script:ontrigger() end
function trigger_ff_script:onendtouch() end
function trigger_ff_script:onfailtouch() end
function trigger_ff_script:onexplode() return EVENT_ALLOWED end
function trigger_ff_script:onbuild() return EVENT_ALLOWED end
function trigger_ff_script:onfailuse() end
function trigger_ff_script:onuse() end
function trigger_ff_script:onactive() end
function trigger_ff_script:oninactive() end
function trigger_ff_script:onremoved() end
function trigger_ff_script:onrestored() end

function trigger_ff_script:spawn() 
	
	-- notify the bot if this is a goal type
	local info = CastToTriggerScript(entity)
	if(info ~= nil) then
		if self.botgoaltype and self.team then
		   info:SetBotGoalInfo(self.botgoaltype, self.team)
		end		
	end
end

-----------------------------------------------------------------------------
-- trigger_ff_clip
-----------------------------------------------------------------------------
trigger_ff_clip = baseclass:new({})
function trigger_ff_clip:spawn()
	local clip = CastToTriggerClip(entity)
	if (clip ~= nil) then
		if self.clipflags then
			clip:SetClipFlags(self.clipflags)
		end
	end
end
-----------------------------------------------------------------------------
-- func_button
-----------------------------------------------------------------------------
func_button = baseclass:new({})
function func_button:allowed() return true end
function func_button:ondamage() end
function func_button:ontouch() end
function func_button:onuse() end
function func_button:onfailuse() end

-----------------------------------------------------------------------------
-- info_ff_script
-----------------------------------------------------------------------------
info_ff_script = baseclass:new({ model = "models/items/healthkit.mdl" })
function info_ff_script:onreturn() end
function info_ff_script:ondrop() end
function info_ff_script:onownerdie() end
function info_ff_script:onownerforcerespawn() end
function info_ff_script:onownerfeign() end
function info_ff_script:onactive() end
function info_ff_script:oninactive() end
function info_ff_script:onremoved() end
function info_ff_script:onrestored() end
function info_ff_script:onexplode() end
function info_ff_script:dropatspawn() return false end
function info_ff_script:usephysics() return false end
function info_ff_script:hasshadow() return true end

-- anims must be named certain things...
function info_ff_script:hasanimation() return false end 

-- For when this object is carried, these offsets are used to place
-- the info_ff_script relative to the objects GetAbsOrigin()
function info_ff_script:attachoffset()
	local offset = Vector( 0, 0, 0 )
	return offset
end

function info_ff_script:precache()
	PrecacheModel(self.model)
end

function info_ff_script:spawn()
	-- set model and skin
	local info = CastToInfoScript( entity )
	info:SetModel(self.model)
	if self.modelskin then
		info:SetSkin(self.modelskin)
	end

	-- setup touch flags
	if self.touchflags ~= nil then info:SetTouchFlags(self.touchflags) end
	if self.disallowtouchflags ~= nil then info:SetDisallowTouchFlags(self.disallowtouchflags) end

	-- notify the bot if this is a goal type
	if(info ~= nil) then
		if self.botgoaltype then
		   info:SetBotGoalInfo(self.botgoaltype)
		end
	end
	
	if self.renderfx ~= nil then
		info:SetRenderFx(self.renderfx)
	end
end

-----------------------------------------------------------------------------
-- info_ff_teamspawn
-----------------------------------------------------------------------------
info_ff_teamspawn = baseclass:new({})
function info_ff_teamspawn:validspawn() return true end
