
-- ff_hunted__classic__.lua

-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------
IncludeScript("base_teamplay")

-----------------------------------------------------------------------------
-- Basic hunted-style gameplay. Respawns all players when the VIP is killed
-----------------------------------------------------------------------------
POINTS_PER_HUNTED_DEATH = 25
POINTS_PER_HUNTED_ESCAPE = 50
POINTS_PER_HUNTED_ESCAPE_FOR_HUNTED = 10

function startup()

	-- set up team names
	SetTeamName( Team.kBlue, "The Hunted" )
	SetTeamName( Team.kRed, "Bodyguards" )
	SetTeamName( Team.kYellow, "Assassins" )
	SetTeamName( Team.kGreen, "Green Kid Touchers" )

	-- set up team limits
	SetPlayerLimit( Team.kBlue, 1 ) -- There can be only one Highlander!
	SetPlayerLimit( Team.kRed, 0 ) -- Unlimited bodyguards.
	SetPlayerLimit( Team.kYellow, 5 ) -- Only 5 assassins, but can we dynamically change this based on maxplayers and/or the current playercount?
	SetPlayerLimit( Team.kGreen, -1 ) -- Fuck green.

	local team = GetTeam( Team.kBlue )
	team:SetAllies( Team.kRed )
	team:SetClassLimit( Player.kScout, -1 )
	team:SetClassLimit( Player.kSniper, -1 )
	team:SetClassLimit( Player.kSoldier, -1 )
	team:SetClassLimit( Player.kDemoman, -1 )
	team:SetClassLimit( Player.kMedic, -1 )
	team:SetClassLimit( Player.kHwguy, -1 )
	team:SetClassLimit( Player.kPyro, -1 )
	team:SetClassLimit( Player.kSpy, -1 )
	team:SetClassLimit( Player.kEngineer, -1 )
	team:SetClassLimit( Player.kCivilian, 0 )

	team = GetTeam( Team.kRed )
	team:SetAllies( Team.kBlue )
	team:SetClassLimit( Player.kScout, -1 )
	team:SetClassLimit( Player.kSniper, -1 )
	team:SetClassLimit( Player.kSoldier, 0 )
	team:SetClassLimit( Player.kDemoman, -1 )
	team:SetClassLimit( Player.kMedic, 0 )
	team:SetClassLimit( Player.kHwguy, 0 )
	team:SetClassLimit( Player.kPyro, -1 )
	team:SetClassLimit( Player.kSpy, -1 )
	team:SetClassLimit( Player.kEngineer, -1 )
	team:SetClassLimit( Player.kCivilian, -1 )

	team = GetTeam( Team.kYellow )
	team:SetClassLimit( Player.kScout, -1 )
	team:SetClassLimit( Player.kSniper, 0 )
	team:SetClassLimit( Player.kSoldier, -1 )
	team:SetClassLimit( Player.kDemoman, -1 )
	team:SetClassLimit( Player.kMedic, -1 )
	team:SetClassLimit( Player.kHwguy, -1 )
	team:SetClassLimit( Player.kPyro, -1 )
	team:SetClassLimit( Player.kSpy, -1 )
	team:SetClassLimit( Player.kEngineer, -1 )
	team:SetClassLimit( Player.kCivilian, -1 )

end

function precache()
	-- Unagi Power!  Unagi!
	PrecacheSound("misc.unagi")
end

function respawn_everyone()
	ApplyToAll({ AT.kRemovePacks, AT.kRemoveProjectiles, AT.kRespawnPlayers, AT.kRemoveBuildables, AT.kRemoveRagdolls, AT.kStopPrimedGrens })
end

function player_onkill( player )
	-- Don't let blue hunted suicide.
	if player:GetTeamId() == Team.kBlue then
		return false
	end
	return true
end

function player_killed( player )
	-- We only care when The Hunted dies
	local player = CastToPlayer( player )

	if player:GetTeamId() == Team.kBlue then
		ConsoleToAll( player:GetName() .. " was assassinated!" )
		BroadCastMessage( "The Hunted was assassinated!" )
		BroadCastSound ( "misc.unagi" )
		local team = GetTeam( Team.kYellow )
		team:AddScore( POINTS_PER_HUNTED_DEATH )
		AddSchedule("respawn_everyone", 2, respawn_everyone)
	end
end


BLOCKTEAMCHANGE = {}

function player_switchteam( player, currentteam, desiredteam )
	local i = player:GetId()
	local stime = GetServerTime()
	
	if desiredteam == Team.kBlue then
		local delaytime = BLOCKTEAMCHANGE[i]
		if delaytime ~= nil and delaytime > stime then
			return false
		end
		
		BLOCKTEAMCHANGE[i] = stime + 10;
	end
	return true
end

-- Give everyone a full resupply, but strip grenades from assassins
function player_spawn( player_entity )
	local player = CastToPlayer( player_entity )

	player:AddHealth( 400 )
	player:AddArmor( 400 )

	player:AddAmmo( Ammo.kNails, 400 )
	player:AddAmmo( Ammo.kShells, 400 )
	player:AddAmmo( Ammo.kRockets, 400 )
	player:AddAmmo( Ammo.kCells, 400 )
	player:AddAmmo( Ammo.kDetpack, 1 )
	player:AddAmmo( Ammo.kGren1, 4 )
	player:AddAmmo( Ammo.kGren2, 4 )

	if player:GetTeamId() == Team.kYellow then
		-- Remove grens
		player:RemoveAmmo( Ammo.kGren1, 4 )
		player:RemoveAmmo( Ammo.kGren2, 4 )
	end
end


-- escape portal entrance
hunted_escape = trigger_ff_script:new({ })

-- escape touch
function hunted_escape:ontouch( touch_entity )

	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		if player:GetTeamId() == Team.kBlue then
			player:AddFrags( POINTS_PER_HUNTED_ESCAPE_FOR_HUNTED )
			ConsoleToAll( player:GetName() .. " escaped!" )
			BroadCastMessage( "The Hunted escaped!" )
			BroadCastSound ( "misc.woop" )

			local team = GetTeam( Team.kBlue )
			team:AddScore( POINTS_PER_HUNTED_ESCAPE )
			team = GetTeam( Team.kRed )
			team:AddScore( POINTS_PER_HUNTED_ESCAPE )

			ApplyToAll({ AT.kRemovePacks, AT.kRemoveProjectiles, AT.kRespawnPlayers, AT.kRemoveBuildables, AT.kRemoveRagdolls, AT.kStopPrimedGrens })
		end
	end

end

-- team specific doors
func_door = trigger_ff_script:new({})
function func_door:allowed( allowed_entity )
	if IsPlayer( allowed_entity ) then
		local player = CastToPlayer( allowed_entity )
		if player:GetTeamId() == self.team then 
			return EVENT_ALLOWED
		end
	end
	return EVENT_DISALLOWED
end
yellow_door = func_door:new({ team = Team.kYellow })

-----------------------------------------------------------------------------
-- entities
-----------------------------------------------------------------------------

-- map map specific 'yellow_door's to the yellow_door lua table
yellow_door_Sewers_1 = yellow_door
yellow_door_BuildingOneNook_2 = yellow_door
yellow_door_BuildingOneBreakRoom = yellow_door
yellow_door_Sewers_2 = yellow_door
yellow_door_BuildingOneNook_1 = yellow_door
yellow_door_Warehouse_1 = yellow_door
yellow_door_RuinsAttic = yellow_door
yellow_door_ShaftRoom = yellow_door
yellow_door_RuinsBathroom_1 = yellow_door
yellow_door_RuinsBathroom_2 = yellow_door
yellow_door_OrgyTower = yellow_door
