-- ff_cz2.lua


-----------------------------------------------------------------------------
-- includes
-----------------------------------------------------------------------------
IncludeScript("base_teamplay")
IncludeScript("base_location")
IncludeScript("base_respawnturret")

-----------------------------------------------------------------------------
-- globals
-----------------------------------------------------------------------------

flags = {"blue_flag", "red_flag"}

-- A global table for storing some team info
team_info = {

	[Team.kUnassigned] = {
		team_name = "neutral",
		enemy_team = Team.kUnassigned,
		ammo_armor_touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kBlue, AllowFlags.kRed, AllowFlags.kYellow, AllowFlags.kGreen},
		skybeam_color = "128 128 128",
		respawnbeam_color = { [0] = 100, [1] = 100, [2] = 100 },
		color_index = 1,
		skin = "0",
		flag_visibility = "TurnOff"
	},

	[Team.kBlue] = {
		team_name = "blue",
		enemy_team = Team.kRed,
		ammo_armor_touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kBlue},
		skybeam_color = "64 64 255",
		respawnbeam_color = { [0] = 100, [1] = 100, [2] = 100 },
		color_index = 2,
		skin = "0",
		flag_visibility = "TurnOn"
	},

	[Team.kRed] = {
		team_name = "red",
		enemy_team = Team.kBlue,
		ammo_armor_touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kRed},
		skybeam_color = "255 64 64",
		respawnbeam_color = { [0] = 100, [1] = 100, [2] = 100 },
		color_index = 0,
		skin = "1",
		flag_visibility = "TurnOn"
	}
}

-- This table is for keeping track of which team controls which CP
command_points = {
	[1] = { controlling_team = Team.kUnassigned, cp_number = 1, point_value = { [Team.kBlue] = 1, [Team.kRed] = 5 }, score_timer_interval = { [Team.kBlue] = 30.00, [Team.kRed] = 15.00 }, hudstatusicon = "hud_cp_1.vtf", hudposx = -40, hudposy = 36, hudalign = 4, hudwidth = 16, hudheight = 16 },
	[2] = { controlling_team = Team.kUnassigned, cp_number = 2, point_value = { [Team.kBlue] = 2, [Team.kRed] = 4 }, score_timer_interval = { [Team.kBlue] = 26.25, [Team.kRed] = 18.75 }, hudstatusicon = "hud_cp_2.vtf", hudposx = -20, hudposy = 36, hudalign = 4, hudwidth = 16, hudheight = 16 },
	[3] = { controlling_team = Team.kUnassigned, cp_number = 3, point_value = { [Team.kBlue] = 3, [Team.kRed] = 3 }, score_timer_interval = { [Team.kBlue] = 22.50, [Team.kRed] = 22.50 }, hudstatusicon = "hud_cp_3.vtf", hudposx = 0, hudposy = 36, hudalign = 4, hudwidth = 16, hudheight = 16 },
	[4] = { controlling_team = Team.kUnassigned, cp_number = 4, point_value = { [Team.kBlue] = 4, [Team.kRed] = 2 }, score_timer_interval = { [Team.kBlue] = 18.75, [Team.kRed] = 26.25 }, hudstatusicon = "hud_cp_4.vtf", hudposx = 20, hudposy = 36, hudalign = 4, hudwidth = 16, hudheight = 16 },
	[5] = { controlling_team = Team.kUnassigned, cp_number = 5, point_value = { [Team.kBlue] = 5, [Team.kRed] = 1 }, score_timer_interval = { [Team.kBlue] = 15.00, [Team.kRed] = 30.00 }, hudstatusicon = "hud_cp_5.vtf", hudposx = 40, hudposy = 36, hudalign = 4, hudwidth = 16, hudheight = 16 }
}

icons = {
	[Team.kBlue] = { teamicon = "hud_cp_blue.vtf" },
	[Team.kRed] = { teamicon = "hud_cp_red.vtf" },
	[Team.kUnassigned] = { teamicon = "hud_cp_neutral.vtf" }
}
	

-- All of the CP ammo and armor (mainly used for removing all ammo and armor when command points reset)
cp_ammo_and_armor_names = {
	"cz2_cp1_ammo",
	"cz2_cp2_ammo",
	"cz2_cp3_ammo",
	"cz2_cp4_ammo",
	"cz2_cp5_ammo",

	"cz2_cp1_armor",
	"cz2_cp2_armor",
	"cz2_cp3_armor",
	"cz2_cp4_armor",
	"cz2_cp5_armor"
}

-- Scoring globals
NUMBER_OF_COMMAND_POINTS = 5
POINTS_FOR_COMPLETE_CONTROL = 100
FLAG_CARRIER_SPEED = 0.8
CC_DESTROY_POINTS = 15
--CP_SCORE_TIMER_INTERVAL = 30

-----------------------------------------------------------------------------
-- global overrides
-----------------------------------------------------------------------------

FLAG_RETURN_TIME = 0

function startup()

	-- set up team limits
	SetPlayerLimit( Team.kYellow, -1 )
	SetPlayerLimit( Team.kGreen, -1 )

	local team = GetTeam(Team.kBlue)
	team:SetClassLimit( Player.kScout, 0 )
	team:SetClassLimit( Player.kSniper, 0 )
	team:SetClassLimit( Player.kSoldier, 0 )
	team:SetClassLimit( Player.kDemoman, 0 )
	team:SetClassLimit( Player.kMedic, 0 )
	team:SetClassLimit( Player.kHwguy, 0 )
	team:SetClassLimit( Player.kPyro, 0 )
	team:SetClassLimit( Player.kSpy, 0 )
	team:SetClassLimit( Player.kEngineer, 0 )
	team:SetClassLimit( Player.kCivilian, -1 )


	local team = GetTeam(Team.kRed)
	team:SetClassLimit( Player.kScout, 0 )
	team:SetClassLimit( Player.kSniper, 0 )
	team:SetClassLimit( Player.kSoldier, 0 )
	team:SetClassLimit( Player.kDemoman, 0 )
	team:SetClassLimit( Player.kMedic, 0 )
	team:SetClassLimit( Player.kHwguy, 0 )
	team:SetClassLimit( Player.kPyro, 0 )
	team:SetClassLimit( Player.kSpy, 0 )
	team:SetClassLimit( Player.kEngineer, 0 )
	team:SetClassLimit( Player.kCivilian, -1 )

	RemoveAllCPAmmoAndArmor()
end

function precache()
	-- precache sounds
	PrecacheSound("yourteam.flagcap")
	PrecacheSound("otherteam.flagcap")
	PrecacheSound("vox.enemystole")

	PrecacheSound("misc.bizwarn")
	PrecacheSound("misc.bloop")
	PrecacheSound("misc.buzwarn")
	PrecacheSound("misc.dadeda")
	PrecacheSound("misc.deeoo")
	PrecacheSound("misc.doop")
	PrecacheSound("misc.woop")

	-- Unagi Power!  Unagi!
	PrecacheSound("misc.unagi")

	PrecacheSound("misc.thunder")

	PrecacheSound("novaprospekt.teleport_post_thunder")
	PrecacheSound("NPC_Ichthyosaur.AttackGrowl")
	PrecacheSound("Streetwar.d3_c17_11_die")
	PrecacheSound("streetwar.Ba_UseConsoleSounds")


end

-----------------------------------------------------------------------------
-- timed scoring
-----------------------------------------------------------------------------
function cp_score_timer( cp_number, team_number )

	local team = GetTeam(team_number)
	team:AddScore(command_points[cp_number].point_value[team_number])

end

function complete_control_notification ( player )

	SmartSound(player, "yourteam.flagcap", "yourteam.flagcap", "otherteam.flagcap")
	SmartMessage(player, "#FF_CZ2_YOURTEAM_COMPLETE", "#FF_CZ2_YOURTEAM_COMPLETE", "#FF_CZ2_OTHERTEAM_COMPLETE")

end

function RemoveAllCPAmmoAndArmor()

	-- Remove all ammo and armor from CPs
	local c = Collection()
	c:GetByName(cp_ammo_and_armor_names, { CF.kNone })
	for item in c.items do
		item = CastToInfoScript(item)
		item:Remove()
	end

end

base_team_trigger = trigger_ff_script:new({ team = Team.kUnassigned, failtouch_message = "" })

function base_team_trigger:allowed( allowed_entity )
	if IsPlayer( allowed_entity ) then
		local player = CastToPlayer( allowed_entity )
		if player:GetTeamId() == self.team then
			return EVENT_ALLOWED
		end
	end
	return EVENT_DISALLOWED
end

function base_team_trigger:onfailtouch( touch_entity )
	if IsPlayer( touch_entity ) then
		local player = CastToPlayer( touch_entity )
		BroadCastMessageToPlayer( player, failtouch_message )
	end
end

blue_door_trigger = base_team_trigger:new({ team = Team.kBlue , failtouch_message = "#FF_NOTALLOWEDDOOR" })
red_door_trigger = base_team_trigger:new({ team = Team.kRed , failtouch_message = "#FF_NOTALLOWEDDOOR" })


-----------------------------------------------------------------------------
-- cz2_base_pack
-----------------------------------------------------------------------------
cz2_base_pack = genericbackpack:new({
	health = 100,
	armor = 300,
	nails = 200,
	shells = 200,
	rockets = 200,
	cells = 200,
	detpacks = 0,
	mancannons = 0,
	gren1 = 0,
	gren2 = 0,
	respawntime = 1,
	touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kBlue, AllowFlags.kRed, AllowFlags.kYellow, AllowFlags.kGreen},
	model = "models/items/backpack/backpack.mdl",
	materializesound = "Item.Materialize",
	touchsound = "Backpack.Touch",
	cp_number = 0,
})

function cz2_base_pack:dropatspawn() return false end

cz2_blue_respawn_pack = cz2_base_pack:new({touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kBlue}})
cz2_red_respawn_pack = cz2_base_pack:new({touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kRed}})

cz2_cp1_ammo = ammobackpack:new({cp_number = 1})
cz2_cp2_ammo = ammobackpack:new({cp_number = 2})
cz2_cp3_ammo = ammobackpack:new({cp_number = 3})
cz2_cp4_ammo = ammobackpack:new({cp_number = 4})
cz2_cp5_ammo = ammobackpack:new({cp_number = 5})

cz2_cp1_armor = armorkit:new({cp_number = 1})
cz2_cp2_armor = armorkit:new({cp_number = 2})
cz2_cp3_armor = armorkit:new({cp_number = 3})
cz2_cp4_armor = armorkit:new({cp_number = 4})
cz2_cp5_armor = armorkit:new({cp_number = 5})


-----------------------------------------------------------------------------
-- cz2_base_grenade_pack
-----------------------------------------------------------------------------
cz2_base_grenade_pack = cz2_base_pack:new({
	detpacks = 1,
	mancannons = 1,
	gren1 = 4,
	gren2 = 4,
	respawntime = 15,
})

cz2_blue_grenade_pack = cz2_base_grenade_pack:new({touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kBlue}})
cz2_red_grenade_pack = cz2_base_grenade_pack:new({touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kRed}})



-----------------------------------------------------------------------------
-- base_cp_trigger
-----------------------------------------------------------------------------

base_cp_trigger = trigger_ff_script:new({
	health = 100,
	armor = 300,
	grenades = 200,
	nails = 200,
	shells = 200,
	rockets = 200,
	cells = 200,
	detpacks = 1,
	mancannons = 1,
	gren1 = 4,
	gren2 = 4,
	item = "",
	team = 0,
	botgoaltype = Bot.kFlagCap,
	cp_number = 0,
})

function base_cp_trigger:ontrigger( trigger_entity )
	if IsPlayer( trigger_entity ) then
		local player = CastToPlayer( trigger_entity )

		-- Allow players on controlling team to teleport back to base
		if player:GetTeamId() == command_points[self.cp_number].controlling_team then

			if player:IsInUse() then
				-- check if the player has a flag
				for i,v in ipairs(flags) do
					-- return the flag
					if player:HasItem(v) then self:ReturnFlagFromPlayer(player) end
				end

				-- respawn the player
				ApplyToPlayer(player, { AT.kRespawnPlayers, kReloadClips })
			else
				BroadCastMessageToPlayer(player, "#FF_CZ2_USE_RESPAWN")
			end

		end
	end
end

function base_cp_trigger:ontouch( trigger_entity )
	if IsPlayer( trigger_entity ) then
		local player = CastToPlayer( trigger_entity )
		local cp = command_points[self.cp_number]

		-- No capping if player's team already controls this CP
		if player:GetTeamId() == cp.controlling_team then return end

		-- Player has to have a flag
		local playerhasflag = false
		for i,v in ipairs(flags) do
			if player:HasItem(v) then playerhasflag = true end
		end

		-- get out if player doesn't have flag
		if not playerhasflag then return end

		self:ReturnFlagFromPlayer(player)

		local new_controlling_team = player:GetTeamId()
		local old_controlling_team = cp.controlling_team

		local c = Collection()
		c:GetByName( { "cz2_cp" .. self.cp_number .. "_ammo", "cz2_cp" .. self.cp_number .. "_armor" }, { CF.kNone } )
		for item in c.items do
			item = CastToInfoScript(item)

			-- restore this CP's ammo and armor, but only if they're already removed (no team was controlling the CP)
			if old_controlling_team == Team.kUnassigned then
				item:Restore()
			end

			-- Also set the touchflags so only the controlling team can use the packs
			item:SetTouchFlags(team_info[new_controlling_team].ammo_armor_touchflags)
		end

		

		-- Give points to team and player
		local team = GetTeam(new_controlling_team)
		team:AddScore(cp.point_value[new_controlling_team])
		player:AddFortPoints((cp.point_value[new_controlling_team]) * 200, "#FF_FORTPOINTS_CAPTUREPOINT")

		-- Find out if any team has complete control
		local team_with_complete_control = Team.kUnassigned
		local control_count = { [Team.kBlue] = 0, [Team.kRed] = 0 }
		control_count[new_controlling_team] = 1
		for i,v in ipairs(command_points) do
			if v.controlling_team ~= Team.kUnassigned and v.cp_number ~= self.cp_number then
				control_count[v.controlling_team] = control_count[v.controlling_team] + 1
			end
			if control_count[v.controlling_team] == NUMBER_OF_COMMAND_POINTS then
				team_with_complete_control = v.controlling_team
			end
		end

		if team_with_complete_control ~= Team.kUnassigned then

			-- Bonus points for complete control
			team:AddScore(POINTS_FOR_COMPLETE_CONTROL)

			AddSchedule("complete_control_notification", 0.1, complete_control_notification, player)
			
			-- Reset all command points
			cp1_trigger:ChangeControllingTeam(Team.kUnassigned)
			cp2_trigger:ChangeControllingTeam(Team.kUnassigned)
			cp3_trigger:ChangeControllingTeam(Team.kUnassigned)
			cp4_trigger:ChangeControllingTeam(Team.kUnassigned)
			cp5_trigger:ChangeControllingTeam(Team.kUnassigned)

			-- reset colors of respawn beams
			OutputEvent( team_info[Team.kBlue].team_name .. "_respawn_beam", "Color", team_info[Team.kUnassigned].respawnbeam_color[0] .. " " .. team_info[Team.kUnassigned].respawnbeam_color[1] .. " " .. team_info[Team.kUnassigned].respawnbeam_color[2] )
			OutputEvent( team_info[Team.kRed].team_name .. "_respawn_beam", "Color", team_info[Team.kUnassigned].respawnbeam_color[0] .. " " .. team_info[Team.kUnassigned].respawnbeam_color[1] .. " " .. team_info[Team.kUnassigned].respawnbeam_color[2] )

			-- Return all flags
			local c = Collection()
			c:GetByName(flags, { CF.kNone })
			for item in c.items do
				item = CastToInfoScript(item)
				item:Return()
			end

			RemoveAllCPAmmoAndArmor()

			ApplyToAll({ AT.kRemovePacks, AT.kRemoveProjectiles, AT.kRespawnPlayers, AT.kRemoveBuildables, AT.kRemoveRagdolls, kReloadClips })
		else
			self:ChangeControllingTeam(new_controlling_team)

			-- change the colors this team's respawn beams
			local beam_team = team_info[new_controlling_team]
			beam_team.respawnbeam_color[beam_team.color_index] = beam_team.respawnbeam_color[Team.kUnassigned] + (control_count[new_controlling_team] * 35)
			OutputEvent( beam_team.team_name .. "_respawn_beam", "Color", beam_team.respawnbeam_color[0] .. " " .. beam_team.respawnbeam_color[1] .. " " .. beam_team.respawnbeam_color[2] )

			-- have to do messages here since player is here
			-- could just pass player to ChangeControllingTeam, but fuck you

			SmartMessage(player, "#FF_CZ2_YOU_CP" .. self.cp_number, "#FF_CZ2_YOURTEAM_CP" .. self.cp_number, "#FF_CZ2_OTHERTEAM_CP" .. self.cp_number)

			-- sounds will get more and more crazy
			-- NOTE: These checks are hardcoded for 5 CPs...if you have more CPs, change how these are checked

			if control_count[new_controlling_team] == 4 then
				SmartSound(player, "misc.unagi", "misc.unagi", "misc.bizwarn")
			elseif control_count[new_controlling_team] == 3 then
				SmartSound(player, "misc.woop", "misc.woop", "misc.buzwarn")
			elseif control_count[new_controlling_team] == 2 then
				SmartSound(player, "misc.doop", "misc.doop", "misc.dadeda")
			else
				SmartSound(player, "misc.bloop", "misc.bloop", "misc.deeoo")
			end


		end

		-- give player some health and armor
		if self.health ~= nil and self.health ~= 0 then player:AddHealth( self.health ) end
		if self.armor ~= nil and self.armor ~= 0 then player:AddArmor( self.armor ) end
	
		-- give player ammo
		if self.nails ~= nil and self.nails ~= 0 then player:AddAmmo(Ammo.kNails, self.nails) end
		if self.shells ~= nil and self.shells ~= 0 then player:AddAmmo(Ammo.kShells, self.shells) end
		if self.rockets ~= nil and self.rockets ~= 0 then player:AddAmmo(Ammo.kRockets, self.rockets) end
		if self.cells ~= nil and self.cells ~= 0 then player:AddAmmo(Ammo.kCells, self.cells) end
		if self.detpacks ~= nil and self.detpacks ~= 0 then player:AddAmmo(Ammo.kDetpack, self.detpacks) end
		if self.mancannons ~= nil and self.mancannons ~= 0 then player:AddAmmo(Ammo.kManCannon, self.mancannons) end
		if self.gren1 ~= nil and self.gren1 ~= 0 then player:AddAmmo(Ammo.kGren1, self.gren1) end
		if self.gren2 ~= nil and self.gren2 ~= 0 then player:AddAmmo(Ammo.kGren2, self.gren2) end

	end
end

function base_cp_trigger:ChangeControllingTeam( new_controlling_team )

		-- Change the skybeam color
		OutputEvent( "cp" .. self.cp_number .. "_skybeam", "Color", team_info[new_controlling_team].skybeam_color )

		-- Change the light color
		for i in pairs(team_info) do
			-- turn off all other lights as well
			local input_name = "TurnOff"
			if i == new_controlling_team then
				input_name = "TurnOn"
			end
			OutputEvent( "cp" .. self.cp_number .. "_light_" .. team_info[i].team_name, input_name )
		end

		-- Change the rotating flag around
		OutputEvent( "cp" .. self.cp_number .. "_flag_rotator", "Reverse")
		OutputEvent( "cp" .. self.cp_number .. "_flag", "Skin", team_info[new_controlling_team].skin )
		OutputEvent( "cp" .. self.cp_number .. "_flag", team_info[new_controlling_team].flag_visibility)

		local cp = command_points[self.cp_number]

		-- remove old flaginfo icons and add new ones
		RemoveHudItemFromAll( self.cp_number .. "-background-" .. cp.controlling_team )
		RemoveHudItemFromAll( self.cp_number .. "-foreground-" .. cp.controlling_team )

		AddHudIconToAll( icons[ new_controlling_team ].teamicon , self.cp_number .. "-background-" .. new_controlling_team , cp.hudposx, cp.hudposy, cp.hudwidth, cp.hudheight, cp.hudalign)
		AddHudIconToAll( cp.hudstatusicon, self.cp_number .. "-foreground-" .. new_controlling_team , cp.hudposx, cp.hudposy, cp.hudwidth, cp.hudheight, cp.hudalign)

		local schedule_name = "cp" .. self.cp_number .. "_score_timer"

		-- stop an existing timer
		if cp.controlling_team ~= Team.kUnassigned then
			RemoveSchedule( schedule_name )
		end

		-- only worry with score timer for Red and Blue
		if new_controlling_team ~= Team.kUnassigned then

			-- start the score timer
			--AddScheduleRepeating( schedule_name, CP_SCORE_TIMER_INTERVAL, cp_score_timer, self.cp_number, new_controlling_team )
			AddScheduleRepeating( schedule_name, cp.score_timer_interval[new_controlling_team], cp_score_timer, self.cp_number, new_controlling_team )

		end

		cp.controlling_team = new_controlling_team

end

function base_cp_trigger:ReturnFlagFromPlayer( player )

		-- Get all carried flags and ...
		local c = Collection()
		c:GetByName(flags, { CF.kInfoScript_Carried, })

		-- ... return the flag that the player is carrying.
		for item in c.items do
			item = CastToInfoScript(item)
			carrier = item:GetCarrier()
			if player:GetId() == carrier:GetId() then
				item:Return()
			end
		end

end

cp1_trigger = base_cp_trigger:new({ cp_number = 1 })
cp2_trigger = base_cp_trigger:new({ cp_number = 2 })
cp3_trigger = base_cp_trigger:new({ cp_number = 3 })
cp4_trigger = base_cp_trigger:new({ cp_number = 4 })
cp5_trigger = base_cp_trigger:new({ cp_number = 5 })


-----------------------------------------------------------------------------
-- base_cp_flag
-----------------------------------------------------------------------------

base_cp_flag = info_ff_script:new({
	name = "Base Flag",
	team = 0,
	model = "models/flag/flag.mdl",
	tosssound = "Flag.Toss",
	modelskin = 0,
	dropnotouchtime = 2,
	capnotouchtime = 2,
	botgoaltype = Bot.kFlag,
	hudicon = "",
	hudx = 5,
	hudy = 180,
	hudalign = 1,
	touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kBlue, AllowFlags.kRed, AllowFlags.kYellow, AllowFlags.kGreen}
})

function base_cp_flag:precache()
	PrecacheSound(self.tosssound)
	info_ff_script.precache(self)
end

function base_cp_flag:spawn()
	self.notouch = { }
	info_ff_script.spawn(self)
end

function base_cp_flag:addnotouch(player_id, duration)
	self.notouch[player_id] = duration
	AddSchedule(self.name .. "-" .. player_id, duration, self.removenotouch, self, player_id)
end

function base_cp_flag.removenotouch(self, player_id)
	self.notouch[player_id] = nil
end

function base_cp_flag:touch( touch_entity )
	local player = CastToPlayer( touch_entity )

	if player:GetTeamId() ~= self.team then return end

	-- pickup if they can
	if self.notouch[player:GetId()] then return end

	-- make sure they don't have any flags already
	for i,v in ipairs(flags) do
		if player:HasItem(v) then return end
	end

	-- if the player is a spy, then force him to lose his disguise
	player:SetDisguisable( false )
	player:SetCloakable( false )

	-- note: this seems a bit backwards (Pickup verb fits Player better)
	local flag = CastToInfoScript(entity)
	flag:Pickup(player)
	player:AddEffect( EF.kSpeedlua1, -1, 0, FLAG_CARRIER_SPEED )
	AddHudIcon( player, self.hudicon, flag:GetName(), self.hudx, self.hudy, self.hudwidth, self.hudheight, self.hudalign )
end

function base_cp_flag:onownerdie( owner_entity )
	-- drop the flag
	local flag = CastToInfoScript(entity)
	flag:Drop(FLAG_RETURN_TIME, 0.0)
end

function base_cp_flag:onownerfeign( owner_entity )
	-- drop the flag
	local flag = CastToInfoScript(entity)
	flag:Drop(FLAG_RETURN_TIME, 0.0)
end
function base_cp_flag:onownercloak( owner_entity )
	-- drop the flag
	local flag = CastToInfoScript(entity)
	flag:Drop(FLAG_RETURN_TIME, 0.0)
end
function base_cp_flag:dropitemcmd( owner_entity )
	-- throw the flag
	local flag = CastToInfoScript(entity)
	flag:Drop(FLAG_RETURN_TIME, FLAG_THROW_SPEED)
end	

function base_cp_flag:ondrop( owner_entity )
	local flag = CastToInfoScript(entity)
	flag:EmitSound(self.tosssound)
end

function base_cp_flag:onloseitem( owner_entity )
	-- let the player that lost the flag put on a disguise
	local player = CastToPlayer( owner_entity )
	player:SetDisguisable(true)
	player:SetCloakable(true)

	self:addnotouch(player:GetId(), self.capnotouchtime)

	player:RemoveEffect( EF.kSpeedlua1 )
	-- remove flag icon from hud
	local flag = CastToInfoScript(entity)
	RemoveHudItem( player, flag:GetName() )
end

function base_cp_flag:onreturn( )
end

blue_flag = base_cp_flag:new({
	team = Team.kBlue,
	modelskin = 0,
	name = "Blue Flag",
	hudicon = "hud_flag_blue.vtf",
	hudx = 5,
	hudy = 180,
	hudwidth = 48,
	hudheight = 48,
	touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kBlue}
})

red_flag = base_cp_flag:new({
	team = Team.kRed,
	modelskin = 1,
	name = "Red Flag",
	hudicon = "hud_flag_red.vtf",
	hudx = 5,
	hudy = 180,
	hudwidth = 48,
	hudheight = 48,
	touchflags = {AllowFlags.kOnlyPlayers,AllowFlags.kRed}
})


-----------------------------------------------------------------------------
-- command centers
-----------------------------------------------------------------------------

base_command_center = trigger_ff_script:new({ team = Team.kUnassigned, enemy_team = Team.kUnassigned })
function base_command_center:onexplode( explosion_entity )
	if IsDetpack( explosion_entity ) then
		local detpack = CastToDetpack(explosion_entity)

		-- don't let assholes destroy their own team's command center
		if detpack:GetTeamId() == self.team then return EVENT_ALLOWED end

		local points = CC_DESTROY_POINTS
		for i,v in ipairs(command_points) do
			if v.controlling_team == self.team then
				-- taking CP 1 away from Red is worth more than taking CP 5 away from them
				points = points + v.point_value[self.team]

				-- Remove all ammo and armor from CPs
				local c = Collection()
				c:GetByName({"cz2_cp" .. v.cp_number .. "_ammo", "cz2_cp" .. v.cp_number .. "_armor"}, { CF.kNone })
				for item in c.items do
					item = CastToInfoScript(item)
					item:Remove()
				end

				-- reset each CP
				if v.cp_number == 1 then cp1_trigger:ChangeControllingTeam(Team.kUnassigned)
				elseif v.cp_number == 2 then cp2_trigger:ChangeControllingTeam(Team.kUnassigned)
				elseif v.cp_number == 3 then cp3_trigger:ChangeControllingTeam(Team.kUnassigned)
				elseif v.cp_number == 4 then cp4_trigger:ChangeControllingTeam(Team.kUnassigned)
				elseif v.cp_number == 5 then cp5_trigger:ChangeControllingTeam(Team.kUnassigned)
				end

			end
		end

		local team = detpack:GetTeam()
		team:AddScore(points)

		local player = detpack:GetOwner()
		player:AddFortPoints(points * 100, "#FF_FORTPOINTS_DESTROY_CC" )

		SmartSound(player, "misc.thunder", "misc.thunder", "misc.thunder")
		SmartMessage(player, "#FF_CZ2_YOU_CC", "#FF_CZ2_YOURTEAM_CC", "#FF_CZ2_OTHERTEAM_CC")

	end

	return EVENT_ALLOWED
end

blue_command_center = base_command_center:new({ team = Team.kBlue, enemy_team = Team.kRed })
red_command_center = base_command_center:new({ team = Team.kRed, enemy_team = Team.kBlue })


-----------------------------------------------------------------------------
-- cz2 Locations
-----------------------------------------------------------------------------

location_blue_command_center = location_info:new({ text = "Command Center", team = BLUE_TEAM })

location_blue_respawn = location_info:new({ text = "Respawn", team = BLUE_TEAM })
location_blue_base = location_info:new({ text = "Base", team = BLUE_TEAM })

location_blue_base_outlook = location_info:new({ text = "Base Outlook", team = BLUE_TEAM })
location_blue_base_outlook_airlift = location_info:new({ text = "Base Outlook Airlift", team = BLUE_TEAM })

location_blue_path_to_cp1 = location_info:new({ text = "Path to CP1", team = BLUE_TEAM })
location_blue_path_to_cp2 = location_info:new({ text = "Path to CP2", team = BLUE_TEAM })


-------------------------------------------
-- cz2 flaginfo
-------------------------------------------

function flaginfo( player_entity )
	local player = CastToPlayer( player_entity )

	for i,v in ipairs(command_points) do

		AddHudIcon( player, icons[ v.controlling_team ].teamicon , v.cp_number .. "-background-" .. v.controlling_team , command_points[v.cp_number].hudposx, command_points[v.cp_number].hudposy, command_points[v.cp_number].hudwidth, command_points[v.cp_number].hudheight, command_points[v.cp_number].hudalign)
		AddHudIcon( player, command_points[v.cp_number].hudstatusicon, v.cp_number .. "-foreground-" .. v.controlling_team , command_points[v.cp_number].hudposx, command_points[v.cp_number].hudposy, command_points[v.cp_number].hudwidth, command_points[v.cp_number].hudheight, command_points[v.cp_number].hudalign)

	end
end
